<?php
/**
 * @copyright   Copyright (C) 2010-2024 Combodo SARL
 * @license     http://opensource.org/licenses/AGPL-3.0
 */

//
// iTop module definition file
//

SetupWebPage::AddModule(
	__FILE__, // Path to the current file, all other file names are relative to the directory containing this file
	'combodo-oauth2-client/1.0.1',
	[
		// Identification
		//
		'label' => 'Oauth2 Client',
		'category' => 'business',

		// Setup
		//
		'dependencies' => [
			'itop-attribute-encrypted-password/1.0.0',
		],
		'mandatory' => false,
		'visible' => false,

		// Components
		//
		'datamodel' => [
			'vendor/autoload.php',
			'model.combodo-oauth2-client.php', // Contains the PHP code generated by the "compilation" of datamodel.combodo-oauth2-client.xml
			'src/Hook/ApplicationUIExtension.php',
		],
		'webservice' => [],
		'data.struct' => [
			// add your 'structure' definition XML files here,
		],
		'data.sample' => [
			// add your sample data XML files here,
		],

		// Documentation
		//
		'doc.manual_setup' => '', // hyperlink to manual setup documentation, if any
		'doc.more_information' => '', // hyperlink to more information, if any

		// Default settings
		//
		'settings' => [
			// Module specific settings go here, if any
		],
	]
);


