<?php
/**
 * Localized data
 *
 * @copyright Copyright (C) 2010-2024 Combodo SAS
 * @license    https://opensource.org/licenses/AGPL-3.0
 * 
 */
/**
 * @author Benjamin Planque <benjamin.planque@combodo.com>
 *
 */
Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:Organization' => 'Organizácia',
	'Class:Organization+' => '~~',
	'Class:Organization/Attribute:name' => 'Názov',
	'Class:Organization/Attribute:name+' => 'Common name~~',
	'Class:Organization/Attribute:code' => 'Kód',
	'Class:Organization/Attribute:code+' => 'Organization code (Siret, DUNS,...)~~',
	'Class:Organization/Attribute:status' => 'Stav',
	'Class:Organization/Attribute:status+' => '~~',
	'Class:Organization/Attribute:status/Value:active' => 'Aktívna',
	'Class:Organization/Attribute:status/Value:active+' => 'Active~~',
	'Class:Organization/Attribute:status/Value:inactive' => 'Neaktívna',
	'Class:Organization/Attribute:status/Value:inactive+' => 'Inactive~~',
	'Class:Organization/Attribute:parent_id' => 'Nadradená organizácia',
	'Class:Organization/Attribute:parent_id+' => 'Parent organization~~',
	'Class:Organization/Attribute:parent_name' => 'Nadradená organizácia',
	'Class:Organization/Attribute:parent_name+' => 'Name of the parent organization~~',
	'Class:Organization/Attribute:deliverymodel_id' => 'Model dodávky',
	'Class:Organization/Attribute:deliverymodel_id+' => '~~',
	'Class:Organization/Attribute:deliverymodel_name' => 'Názov modelu dodávky',
	'Class:Organization/Attribute:deliverymodel_name+' => '~~',
	'Class:Organization/Attribute:parent_id_friendlyname' => 'Nadradená organizácia',
	'Class:Organization/Attribute:parent_id_friendlyname+' => 'Parent organization~~',
	'Class:Organization/Attribute:overview' => 'Overview~~',
	'Organization:Overview:FunctionalCIs' => 'Configuration items of this organization~~',
	'Organization:Overview:FunctionalCIs:subtitle' => 'by type~~',
	'Organization:Overview:Users' => ITOP_APPLICATION_SHORT.' Users within this organization~~',
));

//
// Class: Location
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:Location' => 'Poloha',
	'Class:Location+' => 'Any type of location: Region, Country, City, Site, Building, Floor, Room, Rack,...~~',
	'Class:Location/Attribute:name' => 'Názov',
	'Class:Location/Attribute:name+' => '~~',
	'Class:Location/Attribute:status' => 'Stav',
	'Class:Location/Attribute:status+' => '~~',
	'Class:Location/Attribute:status/Value:active' => 'Aktívna',
	'Class:Location/Attribute:status/Value:active+' => 'Active~~',
	'Class:Location/Attribute:status/Value:inactive' => 'Neaktívna',
	'Class:Location/Attribute:status/Value:inactive+' => 'Inactive~~',
	'Class:Location/Attribute:org_id' => 'Organizácia vlastníka',
	'Class:Location/Attribute:org_id+' => '~~',
	'Class:Location/Attribute:org_name' => 'Názov organizácie vlastníka',
	'Class:Location/Attribute:org_name+' => '~~',
	'Class:Location/Attribute:address' => 'Adresa',
	'Class:Location/Attribute:address+' => 'Postal address~~',
	'Class:Location/Attribute:postal_code' => 'PSČ',
	'Class:Location/Attribute:postal_code+' => 'ZIP/Postal code~~',
	'Class:Location/Attribute:city' => 'Mesto',
	'Class:Location/Attribute:city+' => '~~',
	'Class:Location/Attribute:country' => 'Štát',
	'Class:Location/Attribute:country+' => '~~',
	'Class:Location/Attribute:physicaldevice_list' => 'Zariadenia',
	'Class:Location/Attribute:physicaldevice_list+' => 'All the devices in this location~~',
	'Class:Location/Attribute:person_list' => 'Kontakty',
	'Class:Location/Attribute:person_list+' => 'All the contacts located on this location~~',
));

//
// Class: Contact
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:Contact' => 'Kontakt',
	'Class:Contact+' => '~~',
	'Class:Contact/ComplementaryName' => '%1$s - %2$s~~',
	'Class:Contact/Attribute:name' => 'Meno',
	'Class:Contact/Attribute:name+' => '~~',
	'Class:Contact/Attribute:status' => 'Stav',
	'Class:Contact/Attribute:status+' => '~~',
	'Class:Contact/Attribute:status/Value:active' => 'Aktívny',
	'Class:Contact/Attribute:status/Value:active+' => 'Active~~',
	'Class:Contact/Attribute:status/Value:inactive' => 'Neaktívny',
	'Class:Contact/Attribute:status/Value:inactive+' => 'Inactive~~',
	'Class:Contact/Attribute:org_id' => 'Organizácia',
	'Class:Contact/Attribute:org_id+' => '~~',
	'Class:Contact/Attribute:org_name' => 'Názov Organizácie',
	'Class:Contact/Attribute:org_name+' => '~~',
	'Class:Contact/Attribute:email' => 'Email',
	'Class:Contact/Attribute:email+' => '~~',
	'Class:Contact/Attribute:phone' => 'Telefón',
	'Class:Contact/Attribute:phone+' => '~~',
	'Class:Contact/Attribute:notify' => 'Upozornenie',
	'Class:Contact/Attribute:notify+' => 'Flag which can be used by each notification~~',
	'Class:Contact/Attribute:notify/Value:no' => 'nie',
	'Class:Contact/Attribute:notify/Value:no+' => 'no~~',
	'Class:Contact/Attribute:notify/Value:yes' => 'áno',
	'Class:Contact/Attribute:notify/Value:yes+' => 'yes~~',
	'Class:Contact/Attribute:function' => 'Funkcia',
	'Class:Contact/Attribute:function+' => '~~',
	'Class:Contact/Attribute:cis_list' => 'Zariadenia',
	'Class:Contact/Attribute:cis_list+' => 'All the configuration items linked to this contact~~',
	'Class:Contact/Attribute:finalclass' => 'Typ kontaktu',
	'Class:Contact/Attribute:finalclass+' => 'Name of the final class~~',
));

//
// Class: Person
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:Person' => 'Osoba',
	'Class:Person+' => '~~',
	'Class:Person/ComplementaryName' => '%1$s - %2$s~~',
	'Class:Person/Attribute:name' => 'Priezvisko',
	'Class:Person/Attribute:name+' => '~~',
	'Class:Person/Attribute:first_name' => 'Krstné meno',
	'Class:Person/Attribute:first_name+' => '~~',
	'Class:Person/Attribute:employee_number' => 'Číslo zamestnanca',
	'Class:Person/Attribute:employee_number+' => '~~',
	'Class:Person/Attribute:mobile_phone' => 'Telefónne číslo',
	'Class:Person/Attribute:mobile_phone+' => '~~',
	'Class:Person/Attribute:location_id' => 'Poloha',
	'Class:Person/Attribute:location_id+' => '~~',
	'Class:Person/Attribute:location_name' => 'Názov lokality',
	'Class:Person/Attribute:location_name+' => '~~',
	'Class:Person/Attribute:manager_id' => 'Manažér',
	'Class:Person/Attribute:manager_id+' => '~~',
	'Class:Person/Attribute:manager_name' => 'Meno manažéra',
	'Class:Person/Attribute:manager_name+' => '~~',
	'Class:Person/Attribute:team_list' => 'Tímy',
	'Class:Person/Attribute:team_list+' => 'All the teams this person belongs to~~',
	'Class:Person/Attribute:tickets_list' => 'Tickety',
	'Class:Person/Attribute:tickets_list+' => 'All the tickets this person is the caller~~',
	'Class:Person/Attribute:user_list' => 'Users~~',
	'Class:Person/Attribute:user_list+' => 'All the Users associated to this person~~',
	'Class:Person/Attribute:manager_id_friendlyname' => 'Ľahko čitateľné meno manažéra',
	'Class:Person/Attribute:manager_id_friendlyname+' => '~~',
	'Class:Person/Attribute:picture' => 'Picture~~',
	'Class:Person/Attribute:picture+' => '~~',
	'Class:Person/UniquenessRule:employee_number+' => 'The employee number must be unique in the organization~~',
	'Class:Person/UniquenessRule:employee_number' => 'there is already a person in \'$this->org_name$\' organization with the same employee number~~',
	'Class:Person/UniquenessRule:name+' => 'The employee name should be unique inside its organization~~',
	'Class:Person/UniquenessRule:name' => 'There is already a person in \'$this->org_name$\' organization with the same name~~',
	'Class:Person/Error:ChangingOrgDenied' => 'Impossible to move this person under organization \'%1$s\' as it would break his access to the User Portal, his associated user not being allowed on this organization~~',
));

//
// Class: Team
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:Team' => 'Tím',
	'Class:Team+' => '~~',
	'Class:Team/ComplementaryName' => '%1$s - %2$s~~',
	'Class:Team/Attribute:persons_list' => 'Osoby',
	'Class:Team/Attribute:persons_list+' => 'All the people belonging to this team~~',
	'Class:Team/Attribute:tickets_list' => 'Tickety',
	'Class:Team/Attribute:tickets_list+' => 'All the tickets assigned to this team~~',
));

//
// Class: Document
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:Document' => 'Dokument',
	'Class:Document+' => '~~',
	'Class:Document/ComplementaryName' => '%1$s - %2$s - %3$s~~',
	'Class:Document/Attribute:name' => 'Názov',
	'Class:Document/Attribute:name+' => '~~',
	'Class:Document/Attribute:org_id' => 'Organizácia',
	'Class:Document/Attribute:org_id+' => '~~',
	'Class:Document/Attribute:org_name' => 'Názov Organizácie',
	'Class:Document/Attribute:org_name+' => '~~',
	'Class:Document/Attribute:documenttype_id' => 'Typ dokumentu',
	'Class:Document/Attribute:documenttype_id+' => '~~',
	'Class:Document/Attribute:documenttype_name' => 'Názov typu dokumentu',
	'Class:Document/Attribute:documenttype_name+' => '~~',
	'Class:Document/Attribute:version' => 'Version~~',
	'Class:Document/Attribute:version+' => '~~',
	'Class:Document/Attribute:description' => 'Popis',
	'Class:Document/Attribute:description+' => '~~',
	'Class:Document/Attribute:status' => 'Stav',
	'Class:Document/Attribute:status+' => '~~',
	'Class:Document/Attribute:status/Value:draft' => 'Návrh',
	'Class:Document/Attribute:status/Value:draft+' => '~~',
	'Class:Document/Attribute:status/Value:obsolete' => 'Vyradený',
	'Class:Document/Attribute:status/Value:obsolete+' => '~~',
	'Class:Document/Attribute:status/Value:published' => 'Publikovaný',
	'Class:Document/Attribute:status/Value:published+' => '~~',
	'Class:Document/Attribute:cis_list' => 'Komponenty',
	'Class:Document/Attribute:cis_list+' => 'All the configuration items linked to this document~~',
	'Class:Document/Attribute:finalclass' => 'Typ dokumentu',
	'Class:Document/Attribute:finalclass+' => 'Name of the final class~~',
));

//
// Class: DocumentFile
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:DocumentFile' => 'Dokumentový súbor',
	'Class:DocumentFile+' => '~~',
	'Class:DocumentFile/Attribute:file' => 'Súbor',
	'Class:DocumentFile/Attribute:file+' => '~~',
));

//
// Class: DocumentNote
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:DocumentNote' => 'Poznámka dokumentu',
	'Class:DocumentNote+' => '~~',
	'Class:DocumentNote/Attribute:text' => 'Text',
	'Class:DocumentNote/Attribute:text+' => '~~',
));

//
// Class: DocumentWeb
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:DocumentWeb' => 'Web stránka dokumentu',
	'Class:DocumentWeb+' => '~~',
	'Class:DocumentWeb/Attribute:url' => 'URL',
	'Class:DocumentWeb/Attribute:url+' => '~~',
));

//
// Class: Typology
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:Typology' => 'Typológia',
	'Class:Typology+' => '~~',
	'Class:Typology/Attribute:name' => 'Názov',
	'Class:Typology/Attribute:name+' => '~~',
	'Class:Typology/Attribute:finalclass' => 'Typ',
	'Class:Typology/Attribute:finalclass+' => 'Name of the final class~~',
));

//
// Class: DocumentType
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:DocumentType' => 'Typ dokumentu',
	'Class:DocumentType+' => '~~',
));

//
// Class: ContactType
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:ContactType' => 'Typ kontaktu',
	'Class:ContactType+' => '~~',
));

//
// Class: lnkPersonToTeam
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Class:lnkPersonToTeam' => 'väzba - Osoba / Tím',
	'Class:lnkPersonToTeam+' => '~~',
	'Class:lnkPersonToTeam/Name' => '%1$s / %2$s~~',
	'Class:lnkPersonToTeam/Name+' => '~~',
	'Class:lnkPersonToTeam/Attribute:team_id' => 'Tím',
	'Class:lnkPersonToTeam/Attribute:team_id+' => 'A team to which the person belongs~~',
	'Class:lnkPersonToTeam/Attribute:team_name' => 'Názov tímu',
	'Class:lnkPersonToTeam/Attribute:team_name+' => '~~',
	'Class:lnkPersonToTeam/Attribute:person_id' => 'Osoba',
	'Class:lnkPersonToTeam/Attribute:person_id+' => 'A member of the team~~',
	'Class:lnkPersonToTeam/Attribute:person_name' => 'Meno osoby',
	'Class:lnkPersonToTeam/Attribute:person_name+' => '~~',
	'Class:lnkPersonToTeam/Attribute:role_id' => 'Rola',
	'Class:lnkPersonToTeam/Attribute:role_id+' => 'To select within a typology of possible roles~~',
	'Class:lnkPersonToTeam/Attribute:role_name' => 'Názov role',
	'Class:lnkPersonToTeam/Attribute:role_name+' => '~~',
));

//
// Application Menu
//

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Menu:DataAdministration' => 'Dátová administrácia',
	'Menu:DataAdministration+' => 'Data administration~~',
	'Menu:Catalogs' => 'Katalógy',
	'Menu:Catalogs+' => 'Data types~~',
	'Menu:Audit' => 'Audity',
	'Menu:Audit+' => 'Audit~~',
	'Menu:CSVImport' => 'CSV import~~',
	'Menu:CSVImport+' => 'Bulk creation or update~~',
	'Menu:Organization' => 'Organizácia',
	'Menu:Organization+' => 'All organizations~~',
	'Menu:ConfigManagement' => 'Manažment konfigurácie',
	'Menu:ConfigManagement+' => 'Configuration management~~',
	'Menu:ConfigManagementCI' => 'Konfiguračné položky',
	'Menu:ConfigManagementCI+' => 'Configuration items~~',
	'Menu:ConfigManagementOverview' => 'Prehľad',
	'Menu:ConfigManagementOverview+' => 'Overview~~',
	'Menu:Contact' => 'Kontakty',
	'Menu:Contact+' => 'Contacts~~',
	'Menu:Contact:Count' => '%1$d kontakt/y/ov',
	'Menu:Person' => 'Osoby',
	'Menu:Person+' => 'All persons~~',
	'Menu:Team' => 'Tímy',
	'Menu:Team+' => 'All teams~~',
	'Menu:Document' => 'Dokumenty',
	'Menu:Document+' => 'All documents~~',
	'Menu:Location' => 'Poloha',
	'Menu:Location+' => 'All locations~~',
	'Menu:NewContact' => 'Nový kontakt',
	'Menu:NewContact+' => 'New contact~~',
	'Menu:SearchContacts' => 'Vyhľadať kontakty',
	'Menu:SearchContacts+' => 'Search for contacts~~',
	'Menu:ConfigManagement:Shortcuts' => 'Skratky',
	'Menu:ConfigManagement:AllContacts' => 'Všetky kontakty: %1$d',
	'Menu:Typology' => 'Konfiguračná typológia',
	'Menu:Typology+' => 'Typology configuration~~',
	'UI_WelcomeMenu_AllConfigItems' => 'Zhrnutie',
	'Menu:ConfigManagement:Typology' => 'Konfiguračná typológia',
));

// Add translation for Fieldsets

Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'Person:info' => 'Všeobecné informácie',
	'User:info' => 'Všeobecné informácie',
	'User:profiles' => 'Profiles (minimum one)~~',
	'Person:personal_info' => 'Personal information~~',
	'Person:notifiy' => 'Upozornenie',
));

// Themes
Dict::Add('SK SK', 'Slovak', 'Slovenčina', array(
	'theme:fullmoon' => 'Full moon~~',
	'theme:test-red' => 'Test instance (Red)~~',
));
